/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.xml.v0_6.impl.EntityWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.RelationMemberWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagWriter;

public class RelationWriter
extends EntityWriter {
    private RelationMemberWriter relationMemberWriter;
    private TagWriter tagWriter;

    public RelationWriter(String elementName, int indentLevel) {
        super(elementName, indentLevel);
        this.tagWriter = new TagWriter("tag", indentLevel + 1);
        this.relationMemberWriter = new RelationMemberWriter("member", indentLevel + 1);
    }

    public void process(Relation relation) {
        this.beginOpenElement();
        this.addCommonAttributes((Entity)relation);
        this.addMetatags((Entity)relation);
        List relationMembers = relation.getMembers();
        Collection tags = relation.getTags();
        if (relationMembers.size() > 0 || tags.size() > 0) {
            this.endOpenElement(false);
            for (RelationMember relationMember : relationMembers) {
                this.relationMemberWriter.processRelationMember(relationMember);
            }
            for (Tag tag : tags) {
                this.tagWriter.process(tag);
            }
            this.closeElement();
        } else {
            this.endOpenElement(true);
        }
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.relationMemberWriter.setWriter(writer);
        this.tagWriter.setWriter(writer);
    }
}

