/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.report.v0_6;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class EntityReporter
implements Sink {
    private static final int COLUMN_WIDTH_USER_NAME = 50;
    private static final int COLUMN_WIDTH_NODE_COUNT = 7;
    private static final int COLUMN_WIDTH_WAY_COUNT = 7;
    private static final int COLUMN_WIDTH_RELATION_COUNT = 7;
    private File file;
    private Map<String, UserStatistics> userMap;
    private UserStatistics anonymousUser;
    private UserStatistics totalUser;

    public EntityReporter(File file) {
        this.file = file;
        this.userMap = new HashMap<String, UserStatistics>();
        this.anonymousUser = new UserStatistics("anonymous");
        this.totalUser = new UserStatistics("Total");
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
    }

    @Override
    public void process(EntityContainer entityContainer) {
        UserStatistics user;
        String userName = entityContainer.getEntity().getUser().getName();
        if (userName != null && userName.length() > 0) {
            if (this.userMap.containsKey(userName)) {
                user = this.userMap.get(userName);
            } else {
                user = new UserStatistics(userName);
                this.userMap.put(userName, user);
            }
        } else {
            user = this.anonymousUser;
        }
        entityContainer.process(new EntityProcessor(){
            private UserStatistics processorUser;
            {
                this.processorUser = user;
            }

            @Override
            public void process(BoundContainer bound) {
            }

            @Override
            public void process(NodeContainer node) {
                this.processorUser.incrementNodeCount();
                EntityReporter.this.totalUser.incrementNodeCount();
            }

            @Override
            public void process(WayContainer way) {
                this.processorUser.incrementWayCount();
                EntityReporter.this.totalUser.incrementWayCount();
            }

            @Override
            public void process(RelationContainer relation) {
                this.processorUser.incrementRelationCount();
                EntityReporter.this.totalUser.incrementRelationCount();
            }
        });
    }

    private void writeColumnValue(BufferedWriter writer, String data, int columnWidth) throws IOException {
        int padLength = columnWidth - data.length() + 1;
        if (padLength < 1) {
            padLength = 1;
        }
        writer.write(data);
        for (int i = 0; i < padLength; ++i) {
            writer.write(32);
        }
    }

    private void writeUserLine(BufferedWriter writer, UserStatistics userStatistics) throws IOException {
        this.writeColumnValue(writer, userStatistics.getUserName(), 50);
        this.writeColumnValue(writer, Integer.toString(userStatistics.getNodeCount()), 7);
        this.writeColumnValue(writer, Integer.toString(userStatistics.getWayCount()), 7);
        this.writeColumnValue(writer, Integer.toString(userStatistics.getRelationCount()), 7);
        writer.newLine();
    }

    private void writeUserReport(BufferedWriter writer) throws IOException {
        ArrayList<UserStatistics> userList = new ArrayList<UserStatistics>(this.userMap.values());
        Collections.sort(userList, new Comparator<UserStatistics>(){

            @Override
            public int compare(UserStatistics o1, UserStatistics o2) {
                return o1.getUserName().compareTo(o2.getUserName());
            }
        });
        writer.write("********** User Report **********");
        writer.newLine();
        this.writeColumnValue(writer, "USER NAME", 50);
        this.writeColumnValue(writer, "NODES", 7);
        this.writeColumnValue(writer, "WAYS", 7);
        this.writeColumnValue(writer, "RELNS", 7);
        writer.newLine();
        this.writeUserLine(writer, this.anonymousUser);
        for (UserStatistics userStatistics : userList) {
            this.writeUserLine(writer, userStatistics);
        }
        writer.newLine();
        this.writeUserLine(writer, this.totalUser);
    }

    @Override
    public void complete() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));){
            this.writeUserReport(writer);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write report to file " + this.file + ".");
        }
    }

    @Override
    public void close() {
    }

    private static class UserStatistics {
        private String userName;
        private int nodeCount;
        private int wayCount;
        private int relationCount;

        UserStatistics(String userName) {
            this.userName = userName;
        }

        public void incrementNodeCount() {
            ++this.nodeCount;
        }

        public void incrementWayCount() {
            ++this.wayCount;
        }

        public void incrementRelationCount() {
            ++this.relationCount;
        }

        public String getUserName() {
            return this.userName;
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public int getWayCount() {
            return this.wayCount;
        }

        public int getRelationCount() {
            return this.relationCount;
        }
    }
}

