/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.map.writer.model.TDNode;
import org.mapsforge.map.writer.model.TDWay;
import org.mapsforge.map.writer.util.GeoUtils;

public final class JTSUtils {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static final Logger LOGGER = Logger.getLogger(GeoUtils.class.getName());

    public static Coordinate toCoordinate(TDNode node) {
        return JTSUtils.toCoordinate(node.getLatitude(), node.getLongitude());
    }

    public static Coordinate[] toCoordinates(TDWay way) {
        Coordinate[] coordinates = new Coordinate[way.getWayNodes().length];
        if (way.isReversedInRelation()) {
            for (int i = 0; i < coordinates.length; ++i) {
                coordinates[coordinates.length - 1 - i] = JTSUtils.toCoordinate(way.getWayNodes()[i]);
            }
        } else {
            for (int i = 0; i < coordinates.length; ++i) {
                coordinates[i] = JTSUtils.toCoordinate(way.getWayNodes()[i]);
            }
        }
        return coordinates;
    }

    public static Geometry toJtsGeometry(TDWay way, List<TDWay> innerWays) {
        if (way == null) {
            LOGGER.warning("way is null");
            return null;
        }
        if (way.isForcePolygonLine()) {
            return JTSUtils.buildMultiLineString(way, innerWays);
        }
        if (way.getShape() != 0 || innerWays != null && innerWays.size() > 0) {
            Polygon polygon = JTSUtils.buildPolygon(way, innerWays);
            if (polygon.isValid()) {
                return polygon;
            }
            return JTSUtils.repairInvalidPolygon(polygon);
        }
        return JTSUtils.buildLineString(way);
    }

    static LinearRing buildLinearRing(TDWay way) {
        Coordinate[] coordinates = JTSUtils.toCoordinates(way);
        return GEOMETRY_FACTORY.createLinearRing(coordinates);
    }

    static LineString buildLineString(TDWay way) {
        Coordinate[] coordinates = JTSUtils.toCoordinates(way);
        return GEOMETRY_FACTORY.createLineString(coordinates);
    }

    static MultiLineString buildMultiLineString(TDWay outerWay, List<TDWay> innerWays) {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        lineStrings.add(JTSUtils.buildLineString(outerWay));
        if (innerWays != null) {
            for (TDWay innerWay : innerWays) {
                LineString innerRing = JTSUtils.buildLineString(innerWay);
                lineStrings.add(innerRing);
            }
        }
        return GEOMETRY_FACTORY.createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
    }

    static Polygon buildPolygon(TDWay way) {
        Coordinate[] coordinates = JTSUtils.toCoordinates(way);
        return GEOMETRY_FACTORY.createPolygon(GEOMETRY_FACTORY.createLinearRing(coordinates), null);
    }

    static Polygon buildPolygon(TDWay outerWay, List<TDWay> innerWays) {
        if (innerWays == null || innerWays.isEmpty()) {
            return JTSUtils.buildPolygon(outerWay);
        }
        LinearRing outerRing = JTSUtils.buildLinearRing(outerWay);
        ArrayList<LinearRing> innerRings = new ArrayList<LinearRing>();
        for (TDWay innerWay : innerWays) {
            LinearRing innerRing = JTSUtils.buildLinearRing(innerWay);
            innerRings.add(innerRing);
        }
        if (!innerRings.isEmpty()) {
            LinearRing[] holes = innerRings.toArray(new LinearRing[innerRings.size()]);
            return GEOMETRY_FACTORY.createPolygon(outerRing, holes);
        }
        return null;
    }

    static Geometry repairInvalidPolygon(Geometry p) {
        if (p instanceof Polygon || p instanceof MultiPolygon) {
            Geometry ret = p.buffer(0.0);
            if (ret.getArea() > 0.0) {
                return ret;
            }
            LOGGER.fine("unable to repair invalid polygon");
            return null;
        }
        return p;
    }

    static Geometry toJTSGeometry(TDWay way) {
        return JTSUtils.toJtsGeometry(way, null);
    }

    private static Coordinate toCoordinate(int latitude, int longitude) {
        return new Coordinate(LatLongUtils.microdegreesToDegrees(longitude), LatLongUtils.microdegreesToDegrees(latitude));
    }

    private JTSUtils() {
        throw new IllegalStateException();
    }
}

