/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.model;

import java.util.ArrayList;
import java.util.List;

public class TileCoordinate {
    private final int x;
    private final int y;
    private final byte zoomlevel;

    public TileCoordinate(int x, int y, byte zoomlevel) {
        this.x = x;
        this.y = y;
        this.zoomlevel = zoomlevel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TileCoordinate other = (TileCoordinate)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.zoomlevel == other.zoomlevel;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public byte getZoomlevel() {
        return this.zoomlevel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.zoomlevel;
        return result;
    }

    public String toString() {
        return "TileCoordinate [x=" + this.x + ", y=" + this.y + ", zoomlevel=" + this.zoomlevel + "]";
    }

    public List<TileCoordinate> translateToZoomLevel(byte zoomlevelNew) {
        ArrayList<TileCoordinate> tiles = null;
        int zoomlevelDistance = zoomlevelNew - this.zoomlevel;
        int factor = (int)Math.pow(2.0, Math.abs(zoomlevelDistance));
        if (zoomlevelDistance > 0) {
            tiles = new ArrayList((int)Math.pow(4.0, Math.abs(zoomlevelDistance)));
            int tileUpperLeftX = this.x * factor;
            int tileUpperLeftY = this.y * factor;
            for (int i = 0; i < factor; ++i) {
                for (int j = 0; j < factor; ++j) {
                    tiles.add(new TileCoordinate(tileUpperLeftX + j, tileUpperLeftY + i, zoomlevelNew));
                }
            }
        } else {
            tiles = new ArrayList<TileCoordinate>(1);
            tiles.add(new TileCoordinate(this.x / factor, this.y / factor, zoomlevelNew));
        }
        return tiles;
    }
}

