/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer;

import gnu.trove.iterator.TLongIterator;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapsforge.map.writer.BaseTileBasedDataProcessor;
import org.mapsforge.map.writer.HDTileData;
import org.mapsforge.map.writer.OSMTagMapping;
import org.mapsforge.map.writer.RAMTileData;
import org.mapsforge.map.writer.model.MapWriterConfiguration;
import org.mapsforge.map.writer.model.TDNode;
import org.mapsforge.map.writer.model.TDRelation;
import org.mapsforge.map.writer.model.TDWay;
import org.mapsforge.map.writer.model.TileCoordinate;
import org.mapsforge.map.writer.model.TileData;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.IndexedObjectStore;
import org.openstreetmap.osmosis.core.store.IndexedObjectStoreReader;
import org.openstreetmap.osmosis.core.store.NoSuchIndexElementException;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SimpleObjectStore;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.Storeable;

public final class HDTileBasedDataProcessor
extends BaseTileBasedDataProcessor {
    final TLongObjectMap<List<TDRelation>> additionalRelationTags;
    final TLongObjectMap<TDWay> virtualWays;
    private final IndexedObjectStore<Node> indexedNodeStore = new IndexedObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(Node.class), "idxNodes");
    private final IndexedObjectStore<Way> indexedWayStore = new IndexedObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(Way.class), "idxWays");
    private IndexedObjectStoreReader<Node> nodeIndexReader;
    private final SimpleObjectStore<Relation> relationStore;
    private final HDTileData[][][] tileData;
    private IndexedObjectStoreReader<Way> wayIndexReader;
    private final SimpleObjectStore<Way> wayStore = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(Way.class), "heapWays", true);

    public static HDTileBasedDataProcessor newInstance(MapWriterConfiguration configuration) {
        return new HDTileBasedDataProcessor(configuration);
    }

    private HDTileBasedDataProcessor(MapWriterConfiguration configuration) {
        super(configuration);
        this.relationStore = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(Relation.class), "heapRelations", true);
        this.tileData = new HDTileData[this.zoomIntervalConfiguration.getNumberOfZoomIntervals()][][];
        for (int i = 0; i < this.zoomIntervalConfiguration.getNumberOfZoomIntervals(); ++i) {
            this.tileData[i] = new HDTileData[this.tileGridLayouts[i].getAmountTilesHorizontal()][this.tileGridLayouts[i].getAmountTilesVertical()];
        }
        this.virtualWays = new TLongObjectHashMap<TDWay>();
        this.additionalRelationTags = new TLongObjectHashMap<List<TDRelation>>();
    }

    @Override
    public void addNode(Node node) {
        super.addNode(node);
        this.indexedNodeStore.add(node.getId(), (Storeable)node);
        TDNode tdNode = TDNode.fromNode(node, this.preferredLanguages);
        this.addPOI(tdNode);
    }

    @Override
    public void addRelation(Relation relation) {
        super.addRelation(relation);
        this.relationStore.add((Storeable)relation);
    }

    @Override
    public void addWay(Way way) {
        super.addWay(way);
        this.wayStore.add((Storeable)way);
        this.indexedWayStore.add(way.getId(), (Storeable)way);
        this.maxWayID = Math.max(way.getId(), this.maxWayID);
    }

    @Override
    public void close() {
        this.indexedNodeStore.close();
        this.indexedWayStore.close();
        this.wayStore.close();
        this.relationStore.close();
    }

    @Override
    public void complete() {
        this.indexedNodeStore.complete();
        this.nodeIndexReader = this.indexedNodeStore.createReader();
        this.indexedWayStore.complete();
        this.wayIndexReader = this.indexedWayStore.createReader();
        LOGGER.info("handle coastlines" + (this.tagValues ? " and implicit way relations..." : "..."));
        long nWays = 0L;
        ReleasableIterator wayReader = this.wayStore.iterate();
        while (wayReader.hasNext()) {
            Way way;
            TDWay tdWay;
            if (this.progressLogs && ++nWays % 10000L == 0L) {
                System.out.print("Ways: " + this.nfCounts.format(nWays) + " / " + this.nfCounts.format(this.getWaysNumber()) + "\r");
            }
            if ((tdWay = TDWay.fromWay(way = (Way)wayReader.next(), this, this.preferredLanguages)) == null) continue;
            this.prepareImplicitWayRelations(tdWay);
        }
        this.handleImplicitWayRelations();
        LOGGER.info("handle relations...");
        ReleasableIterator relationReader = this.relationStore.iterate();
        BaseTileBasedDataProcessor.RelationHandler relationHandler = new BaseTileBasedDataProcessor.RelationHandler(this);
        while (relationReader.hasNext()) {
            Relation entry = (Relation)relationReader.next();
            TDRelation tdRelation = TDRelation.fromRelation(entry, this, this.preferredLanguages);
            relationHandler.execute(tdRelation);
        }
        LOGGER.info("handle ways...");
        wayReader = this.wayStore.iterate();
        BaseTileBasedDataProcessor.WayHandler wayHandler = new BaseTileBasedDataProcessor.WayHandler(this);
        while (wayReader.hasNext()) {
            Way way = (Way)wayReader.next();
            TDWay tdWay = TDWay.fromWay(way, this, this.preferredLanguages);
            if (tdWay == null) continue;
            List<TDRelation> associatedRelations = this.additionalRelationTags.get(tdWay.getId());
            if (associatedRelations != null) {
                for (TDRelation tileDataRelation : associatedRelations) {
                    tdWay.mergeRelationInformation(tileDataRelation);
                }
            }
            wayHandler.execute(tdWay);
        }
        OSMTagMapping.getInstance().optimizePoiOrdering(this.histogramPoiTags);
        OSMTagMapping.getInstance().optimizeWayOrdering(this.histogramWayTags);
    }

    @Override
    public Set<TDWay> getCoastLines(TileCoordinate tc) {
        if (tc.getZoomlevel() <= 12) {
            return Collections.emptySet();
        }
        TileCoordinate correspondingOceanTile = tc.translateToZoomLevel((byte)12).get(0);
        if (this.wayIndexReader == null) {
            throw new IllegalStateException("way store not accessible, call complete() first");
        }
        TLongHashSet coastlines = (TLongHashSet)this.tilesToCoastlines.get(correspondingOceanTile);
        if (coastlines == null) {
            return Collections.emptySet();
        }
        TLongIterator it = coastlines.iterator();
        HashSet<TDWay> coastlinesAsTDWay = new HashSet<TDWay>(coastlines.size());
        while (it.hasNext()) {
            long id = it.next();
            TDWay tdWay = null;
            try {
                tdWay = TDWay.fromWay((Way)this.wayIndexReader.get(id), this, this.preferredLanguages);
            }
            catch (NoSuchIndexElementException e) {
                LOGGER.finer("coastline way non-existing" + id);
            }
            if (tdWay == null) continue;
            coastlinesAsTDWay.add(tdWay);
        }
        return coastlinesAsTDWay;
    }

    @Override
    public synchronized List<TDWay> getInnerWaysOfMultipolygon(long outerWayID) {
        TLongArrayList innerwayIDs = (TLongArrayList)this.outerToInnerMapping.get(outerWayID);
        if (innerwayIDs == null) {
            return null;
        }
        return this.getInnerWaysOfMultipolygon(innerwayIDs.toArray());
    }

    @Override
    public TDNode getNode(long id) {
        if (this.nodeIndexReader == null) {
            throw new IllegalStateException("node store not accessible, call complete() first");
        }
        try {
            return TDNode.fromNode((Node)this.nodeIndexReader.get(id), this.preferredLanguages);
        }
        catch (NoSuchIndexElementException e) {
            LOGGER.finer("node cannot be found in index: " + id);
            return null;
        }
    }

    @Override
    public TileData getTile(int baseZoomIndex, int tileCoordinateX, int tileCoordinateY) {
        HDTileData hdt = this.getTileImpl(baseZoomIndex, tileCoordinateX, tileCoordinateY);
        if (hdt == null) {
            return null;
        }
        return this.fromHDTileData(hdt);
    }

    @Override
    public TDWay getWay(long id) {
        if (this.wayIndexReader == null) {
            throw new IllegalStateException("way store not accessible, call complete() first");
        }
        try {
            return TDWay.fromWay((Way)this.wayIndexReader.get(id), this, this.preferredLanguages);
        }
        catch (NoSuchIndexElementException e) {
            LOGGER.finer("way cannot be found in index: " + id);
            return null;
        }
    }

    @Override
    protected HDTileData getTileImpl(int zoom, int tileX, int tileY) {
        int tileCoordinateXIndex = tileX - this.tileGridLayouts[zoom].getUpperLeft().getX();
        int tileCoordinateYIndex = tileY - this.tileGridLayouts[zoom].getUpperLeft().getY();
        if (tileCoordinateXIndex < 0 || tileCoordinateYIndex < 0 || this.tileData[zoom].length <= tileCoordinateXIndex || this.tileData[zoom][tileCoordinateXIndex].length <= tileCoordinateYIndex) {
            return null;
        }
        HDTileData td = this.tileData[zoom][tileCoordinateXIndex][tileCoordinateYIndex];
        if (td == null) {
            this.tileData[zoom][tileCoordinateXIndex][tileCoordinateYIndex] = td = new HDTileData();
        }
        return td;
    }

    @Override
    protected void handleAdditionalRelationTags(TDWay way, TDRelation relation) {
        List<TDRelation> associatedRelations = this.additionalRelationTags.get(way.getId());
        if (associatedRelations == null) {
            associatedRelations = new ArrayList<TDRelation>();
            this.additionalRelationTags.put(way.getId(), associatedRelations);
        }
        associatedRelations.add(relation);
    }

    @Override
    protected void handleVirtualInnerWay(TDWay virtualWay) {
        this.virtualWays.put(virtualWay.getId(), virtualWay);
    }

    @Override
    protected void handleVirtualOuterWay(TDWay virtualWay) {
        this.virtualWays.put(virtualWay.getId(), virtualWay);
    }

    private RAMTileData fromHDTileData(HDTileData hdt) {
        RAMTileData td = new RAMTileData();
        TLongIterator it = hdt.getPois().iterator();
        while (it.hasNext()) {
            td.addPOI(TDNode.fromNode((Node)this.nodeIndexReader.get(it.next()), this.preferredLanguages));
        }
        it = hdt.getWays().iterator();
        while (it.hasNext()) {
            List<TDRelation> associatedRelations;
            TDWay way = null;
            long id = it.next();
            try {
                way = TDWay.fromWay((Way)this.wayIndexReader.get(id), this, this.preferredLanguages);
                td.addWay(way);
            }
            catch (NoSuchIndexElementException e) {
                way = this.virtualWays.get(id);
                if (way != null) {
                    td.addWay(way);
                }
                LOGGER.finer("referenced way non-existing" + id);
            }
            if (way == null) continue;
            this.addImplicitRelationInformation(way);
            if (this.outerToInnerMapping.contains(way.getId())) {
                way.setShape((byte)2);
            }
            if ((associatedRelations = this.additionalRelationTags.get(id)) == null) continue;
            for (TDRelation tileDataRelation : associatedRelations) {
                way.mergeRelationInformation(tileDataRelation);
            }
        }
        return td;
    }

    private List<TDWay> getInnerWaysOfMultipolygon(long[] innerWayIDs) {
        if (innerWayIDs == null) {
            return Collections.emptyList();
        }
        ArrayList<TDWay> res = new ArrayList<TDWay>();
        for (long id : innerWayIDs) {
            TDWay current;
            block4: {
                current = null;
                try {
                    current = TDWay.fromWay((Way)this.wayIndexReader.get(id), this, this.preferredLanguages);
                }
                catch (NoSuchIndexElementException e) {
                    current = this.virtualWays.get(id);
                    if (current != null) break block4;
                    LOGGER.fine("multipolygon with outer way id " + id + " references non-existing inner way " + id);
                    continue;
                }
            }
            res.add(current);
        }
        return res;
    }
}

