/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import org.mapsforge.core.model.LatLong;

public class MapPosition {
    public final LatLong latLong;
    public final byte zoomLevel;

    public MapPosition(LatLong latLong, byte zoomLevel) {
        if (latLong == null) {
            throw new IllegalArgumentException("latLong must not be null");
        }
        if (zoomLevel < 0) {
            throw new IllegalArgumentException("zoomLevel must not be negative: " + zoomLevel);
        }
        this.latLong = latLong;
        this.zoomLevel = zoomLevel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapPosition)) {
            return false;
        }
        MapPosition other = (MapPosition)obj;
        if (!this.latLong.equals(other.latLong)) {
            return false;
        }
        return this.zoomLevel == other.zoomLevel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.latLong.hashCode();
        result = 31 * result + this.zoomLevel;
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("latLong=");
        stringBuilder.append(this.latLong);
        stringBuilder.append(", zoomLevel=");
        stringBuilder.append(this.zoomLevel);
        return stringBuilder.toString();
    }
}

