/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityFeatureMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class EntityFeatureDao<Tef extends Storeable, Tdb extends DbFeature<Tef>> {
    private EntityFeatureMapper<Tdb> entityFeatureMapper;
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    protected EntityFeatureDao(JdbcTemplate jdbcTemplate, EntityFeatureMapper<Tdb> entityFeatureMapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.entityFeatureMapper = entityFeatureMapper;
    }

    public Collection<Tdb> getAll(long entityId) {
        return this.jdbcTemplate.query(this.entityFeatureMapper.getSqlSelect("", true, true), new Object[]{entityId}, this.entityFeatureMapper.getRowMapper());
    }

    public Collection<Tef> getAllRaw(long entityId) {
        Collection<Tdb> dbFeatures = this.getAll(entityId);
        ArrayList<Storeable> rawFeatures = new ArrayList<Storeable>(dbFeatures.size());
        for (DbFeature dbFeature : dbFeatures) {
            rawFeatures.add(dbFeature.getFeature());
        }
        return rawFeatures;
    }

    public void addAll(Collection<Tdb> features) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        for (DbFeature feature : features) {
            args.clear();
            this.entityFeatureMapper.populateParameters(args, feature);
            this.namedParameterJdbcTemplate.update(this.entityFeatureMapper.getSqlInsert(1), args);
        }
    }

    public void removeList(long entityId) {
        this.jdbcTemplate.update(this.entityFeatureMapper.getSqlDelete(true), new Object[]{entityId});
    }
}

