/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6;

import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.database.DatabaseLocker;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.NodeLocationStoreType;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.CopyFilesetBuilder;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.CopyFilesetLoader;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.TempCopyFileset;

public class PostgreSqlCopyWriter
implements Sink {
    private static final Logger LOG = Logger.getLogger(PostgreSqlCopyWriter.class.getName());
    private CopyFilesetBuilder copyFilesetBuilder;
    private CopyFilesetLoader copyFilesetLoader;
    private TempCopyFileset copyFileset;
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private NodeLocationStoreType storeType;
    private boolean populateBbox;
    private boolean populateLinestring;
    private boolean keepInvalidWays;
    private boolean initialized;
    private DatabaseContext dbCtx;
    private DatabaseLocker locker;

    public PostgreSqlCopyWriter(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, NodeLocationStoreType storeType, boolean keepInvalidWays) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.storeType = storeType;
        this.keepInvalidWays = keepInvalidWays;
        this.dbCtx = new DatabaseContext(loginCredentials);
        this.locker = new DatabaseLocker(this.dbCtx.getDataSource(), true);
        this.copyFileset = new TempCopyFileset();
    }

    private void initialize() {
        if (!this.initialized) {
            LOG.fine("Initializing the database and temporary processing files.");
            DatabaseCapabilityChecker capabilityChecker = new DatabaseCapabilityChecker(this.dbCtx);
            this.populateBbox = capabilityChecker.isWayBboxSupported();
            this.populateLinestring = capabilityChecker.isWayLinestringSupported();
            this.copyFilesetBuilder = new CopyFilesetBuilder(this.copyFileset, this.populateBbox, this.populateLinestring, this.storeType, this.keepInvalidWays);
            this.copyFilesetLoader = new CopyFilesetLoader(this.loginCredentials, this.preferences, this.copyFileset);
            LOG.fine("Processing input data, building geometries and creating database load files.");
            this.locker.lockDatabase(this.getClass().getSimpleName());
            this.initialized = true;
        }
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void process(EntityContainer entityContainer) {
        this.initialize();
        this.copyFilesetBuilder.process(entityContainer);
    }

    public void complete() {
        this.initialize();
        this.copyFilesetBuilder.complete();
        LOG.fine("All data has been received, beginning database load.");
        this.copyFilesetLoader.run();
        LOG.fine("Processing complete.");
    }

    public void close() {
        if (this.copyFilesetBuilder != null) {
            this.copyFilesetBuilder.close();
            this.copyFilesetBuilder = null;
        }
        this.copyFileset.close();
        this.locker.unlockDatabase();
        this.dbCtx.close();
        this.initialized = false;
    }
}

