/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MonoclePixels;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javafx.application.Platform;

class MonocleRobot
extends Robot {
    MonocleRobot() {
    }

    @Override
    protected void _create() {
    }

    @Override
    protected void _destroy() {
    }

    @Override
    protected void _keyPress(int n) {
        Platform.runLater(() -> {
            KeyState keyState = new KeyState();
            KeyInput.getInstance().getState(keyState);
            keyState.pressKey(n);
            KeyInput.getInstance().setState(keyState);
        });
    }

    @Override
    protected void _keyRelease(int n) {
        Platform.runLater(() -> {
            KeyState keyState = new KeyState();
            KeyInput.getInstance().getState(keyState);
            keyState.releaseKey(n);
            KeyInput.getInstance().setState(keyState);
        });
    }

    @Override
    protected void _mouseMove(int n, int n2) {
        Platform.runLater(() -> {
            MouseState mouseState = new MouseState();
            MouseInput.getInstance().getState(mouseState);
            mouseState.setX(n);
            mouseState.setY(n2);
            MouseInput.getInstance().setState(mouseState, false);
        });
    }

    @Override
    protected void _mousePress(int n) {
        Platform.runLater(() -> {
            MouseState mouseState = new MouseState();
            MouseInput.getInstance().getState(mouseState);
            if ((n & 1) != 0) {
                mouseState.pressButton(212);
            }
            if ((n & 4) != 0) {
                mouseState.pressButton(214);
            }
            if ((n & 2) != 0) {
                mouseState.pressButton(213);
            }
            MouseInput.getInstance().setState(mouseState, false);
        });
    }

    @Override
    protected void _mouseRelease(int n) {
        Platform.runLater(() -> {
            MouseState mouseState = new MouseState();
            MouseInput.getInstance().getState(mouseState);
            if ((n & 1) != 0) {
                mouseState.releaseButton(212);
            }
            if ((n & 4) != 0) {
                mouseState.releaseButton(214);
            }
            if ((n & 2) != 0) {
                mouseState.releaseButton(213);
            }
            MouseInput.getInstance().setState(mouseState, false);
        });
    }

    @Override
    protected void _mouseWheel(int n) {
        Platform.runLater(() -> {
            MouseState mouseState = new MouseState();
            MouseInput mouseInput = MouseInput.getInstance();
            mouseInput.getState(mouseState);
            int n2 = n < 0 ? -1 : 1;
            for (int i = 0; i < Math.abs(n); ++i) {
                mouseState.setWheel(n2);
                mouseInput.setState(mouseState, false);
                mouseState.setWheel(0);
                mouseInput.setState(mouseState, false);
            }
        });
    }

    @Override
    protected int _getMouseX() {
        MouseState mouseState = new MouseState();
        MouseInput.getInstance().getState(mouseState);
        return mouseState.getX();
    }

    @Override
    protected int _getMouseY() {
        MouseState mouseState = new MouseState();
        MouseInput.getInstance().getState(mouseState);
        return mouseState.getY();
    }

    @Override
    protected int _getPixelColor(int n, int n2) {
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        int n3 = nativeScreen.getDepth() >>> 3;
        int n4 = nativeScreen.getWidth();
        int n5 = nativeScreen.getHeight();
        if (n < 0 || n > n4 || n2 < 0 || n2 > n5) {
            return 0;
        }
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            ByteBuffer byteBuffer = nativeScreen.getScreenCapture();
            if (n3 == 2) {
                ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                short s = shortBuffer.get(n2 * n4 + n);
                int n6 = (s & 0xF800) >> 11 << 3;
                int n7 = (s & 0x7E0) >> 5 << 2;
                int n8 = (s & 0x1F) << 3;
                int n9 = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
                return n9;
            }
            if (n3 >= 4) {
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                return intBuffer.get(n2 * n4 + n);
            }
            throw new RuntimeException("Unknown bit depth");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Pixels _getScreenCapture(int n, int n2, int n3, int n4, boolean bl) {
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        int n5 = nativeScreen.getDepth() >>> 3;
        int n6 = nativeScreen.getWidth();
        int n7 = nativeScreen.getHeight();
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            IntBuffer intBuffer = nativeScreen.getScreenCapture().asIntBuffer();
            if (n == 0 && n2 == 0 && n3 == n6 && n4 == n7) {
                return new MonoclePixels(n3, n4, intBuffer);
            }
            IntBuffer intBuffer2 = IntBuffer.allocate(n3 * n4);
            int n8 = Math.min(n2 + n4, n7);
            int n9 = Math.min(n + n3, n6);
            for (int i = n2; i < n8; ++i) {
                for (int j = n; j < n9; ++j) {
                    intBuffer2.put(intBuffer.get(i * n6 + j));
                }
            }
            intBuffer2.rewind();
            return new MonoclePixels(n3, n4, intBuffer2);
        }
    }
}

