/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.areafilter.v0_6;

import org.openstreetmap.osmosis.areafilter.v0_6.AreaFilter;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerType;

public class BoundingBoxFilter
extends AreaFilter {
    private Bound bound;

    public BoundingBoxFilter(IdTrackerType idTrackerType, double left, double right, double top, double bottom, boolean clipIncompleteEntities, boolean completeWays, boolean completeRelations, boolean cascadingRelations) {
        super(idTrackerType, clipIncompleteEntities, completeWays, completeRelations, cascadingRelations);
        this.bound = new Bound(right, left, top, bottom, "");
    }

    @Override
    public void process(BoundContainer boundContainer) {
        Bound newBound = boundContainer.getEntity().intersect(this.bound);
        if (newBound != null) {
            super.process(new BoundContainer(newBound));
        }
    }

    @Override
    protected boolean isNodeWithinArea(Node node) {
        double latitude = node.getLatitude();
        double longitude = node.getLongitude();
        for (Bound b : this.bound.toSimpleBound()) {
            if (!(b.getTop() >= latitude) || !(b.getBottom() <= latitude) || !(b.getLeft() <= longitude) || !(b.getRight() >= longitude)) continue;
            return true;
        }
        return false;
    }
}

