/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagfilter.v0_6;

import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class NodeKeyFilter
implements SinkSource,
EntityProcessor {
    private Sink sink;
    private HashSet<String> allowedKeys = new HashSet();

    public NodeKeyFilter(String keyList) {
        String[] keys = keyList.split(",");
        for (int i = 0; i < keys.length; ++i) {
            this.allowedKeys.add(keys[i]);
        }
    }

    public void initialize(Map<String, Object> metaData) {
        this.sink.initialize(metaData);
    }

    public void process(EntityContainer entityContainer) {
        entityContainer.process((EntityProcessor)this);
    }

    public void process(BoundContainer boundContainer) {
        this.sink.process((EntityContainer)boundContainer);
    }

    public void process(NodeContainer container) {
        Node node = container.getEntity();
        boolean matchesFilter = false;
        for (Tag tag : node.getTags()) {
            if (!this.allowedKeys.contains(tag.getKey())) continue;
            matchesFilter = true;
            break;
        }
        if (matchesFilter) {
            this.sink.process((EntityContainer)container);
        }
    }

    public void process(WayContainer container) {
    }

    public void process(RelationContainer container) {
    }

    public void complete() {
        this.sink.complete();
    }

    public void close() {
        this.sink.close();
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

