/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.time.DateFormatter;
import org.openstreetmap.osmosis.core.time.DateParser;

public class TimestampTracker {
    private File timestampFile;
    private File newTimestampFile;
    private DateParser dateParser;
    private DateFormatter dateFormatter;

    public TimestampTracker(File timestampFile, File newTimestampFile) {
        this.timestampFile = timestampFile;
        this.newTimestampFile = newTimestampFile;
        this.dateParser = new DateParser();
        this.dateFormatter = new DateFormatter();
    }

    private void renameNewFileToCurrent() {
        if (!this.newTimestampFile.exists()) {
            throw new OsmosisRuntimeException("Can't rename non-existent file " + this.newTimestampFile + ".");
        }
        if (this.timestampFile.exists() && !this.timestampFile.delete()) {
            throw new OsmosisRuntimeException("Unable to delete file " + this.timestampFile + ".");
        }
        if (!this.newTimestampFile.renameTo(this.timestampFile)) {
            throw new OsmosisRuntimeException("Unable to rename file " + this.newTimestampFile + " to " + this.timestampFile + ".");
        }
    }

    public Date getTime() {
        Date date;
        BufferedReader reader = new BufferedReader(new FileReader(this.timestampFile));
        try {
            date = this.dateParser.parse(reader.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to read the time from file " + this.timestampFile + ".", (Throwable)e);
            }
        }
        reader.close();
        return date;
    }

    public void setTime(Date time) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.newTimestampFile));){
            writer.write(this.dateFormatter.format(time));
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write the time to temporary file " + this.newTimestampFile + ".", (Throwable)e);
        }
        this.renameNewFileToCurrent();
    }
}

