/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.MemberTypeValueMapper;

public class RelationMemberMapper
extends EntityFeatureMapper<DbOrderedFeature<RelationMember>> {
    private MemberTypeValueMapper memberTypeValueMapper = new MemberTypeValueMapper();

    @Override
    public String getParentEntityName() {
        return "relation";
    }

    @Override
    public String getEntityName() {
        return "relation_members";
    }

    @Override
    public String getSqlSelect(boolean filterByEntityId, boolean orderBy) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT relation_id AS entity_id, member_id, member_type, member_role, sequence_id FROM ");
        resultSql.append("relation_members f");
        if (filterByEntityId) {
            resultSql.append(" WHERE entity_id = ?");
        }
        if (orderBy) {
            resultSql.append(this.getSqlDefaultOrderBy());
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDefaultOrderBy() {
        return super.getSqlDefaultOrderBy() + ", sequence_id";
    }

    @Override
    public String getSqlInsert(int rowCount) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("INSERT INTO relation_members (");
        resultSql.append("relation_id, member_id, member_type, member_role, sequence_id) VALUES ");
        for (int row = 0; row < rowCount; ++row) {
            if (row > 0) {
                resultSql.append(", ");
            }
            resultSql.append("(?, ?, ?, ?, ?)");
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDelete(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("DELETE FROM relation_members");
        if (filterByEntityId) {
            resultSql.append(" WHERE ").append("relation_id = ?");
        }
        return resultSql.toString();
    }

    @Override
    public DbOrderedFeature<RelationMember> buildEntity(ResultSet resultSet) {
        try {
            return new DbOrderedFeature(resultSet.getLong("entity_id"), (Storeable)new RelationMember(resultSet.getLong("member_id"), this.memberTypeValueMapper.getEntityType(resultSet.getString("member_type")), resultSet.getString("member_role")), resultSet.getInt("sequence_id"));
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to build a relation member from the current recordset row.", (Throwable)e);
        }
    }

    @Override
    public int populateEntityParameters(PreparedStatement statement, int initialIndex, DbOrderedFeature<RelationMember> entityFeature) {
        try {
            RelationMember relationMember = (RelationMember)entityFeature.getFeature();
            int prmIndex = initialIndex;
            statement.setLong(prmIndex++, entityFeature.getEntityId());
            statement.setLong(prmIndex++, relationMember.getMemberId());
            statement.setString(prmIndex++, this.memberTypeValueMapper.getMemberType(relationMember.getMemberType()));
            statement.setString(prmIndex++, relationMember.getMemberRole());
            statement.setInt(prmIndex++, entityFeature.getSequenceId());
            return prmIndex;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to populate relation member parameters for relation " + entityFeature.getEntityId() + ".", (Throwable)e);
        }
    }
}

