/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.NodeMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.NodeReader;

public class NodeDao
extends EntityDao<Node> {
    private static final String SQL_UPDATE_WAY_BBOX = "UPDATE ways w SET bbox = ( SELECT ST_Envelope(ST_Collect(n.geom)) FROM nodes n INNER JOIN way_nodes wn ON wn.node_id = n.id WHERE wn.way_id = w.id ) WHERE w.id IN ( SELECT w.id FROM ways w INNER JOIN way_nodes wn ON w.id = wn.way_id WHERE wn.node_id = ? GROUP BY w.id )";
    private static final String SQL_UPDATE_WAY_LINESTRING = "UPDATE ways w SET linestring = ( SELECT ST_MakeLine(c.geom) AS way_line FROM ( SELECT n.geom AS geom FROM nodes n INNER JOIN way_nodes wn ON n.id = wn.node_id WHERE (wn.way_id = w.id) ORDER BY wn.sequence_id ) c ) WHERE w.id IN ( SELECT w.id FROM ways w INNER JOIN way_nodes wn ON w.id = wn.way_id WHERE wn.node_id = ? GROUP BY w.id )";
    private DatabaseCapabilityChecker capabilityChecker;
    private PreparedStatement updateWayBboxStatement;
    private PreparedStatement updateWayLinestringStatement;

    public NodeDao(DatabaseContext dbCtx, ActionDao actionDao) {
        super(dbCtx, new NodeMapper(), actionDao);
        this.capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
    }

    @Override
    protected void loadFeatures(long entityId, Node entity) {
    }

    @Override
    public void modifyEntity(Node entity) {
        int prmIndex;
        super.modifyEntity(entity);
        if (this.capabilityChecker.isWayBboxSupported()) {
            if (this.updateWayBboxStatement == null) {
                this.updateWayBboxStatement = this.prepareStatement(SQL_UPDATE_WAY_BBOX);
            }
            try {
                prmIndex = 1;
                this.updateWayBboxStatement.setLong(prmIndex++, entity.getId());
                this.updateWayBboxStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Update bbox failed for node " + entity.getId() + ".");
            }
        }
        if (this.capabilityChecker.isWayLinestringSupported()) {
            if (this.updateWayLinestringStatement == null) {
                this.updateWayLinestringStatement = this.prepareStatement(SQL_UPDATE_WAY_LINESTRING);
            }
            try {
                prmIndex = 1;
                this.updateWayLinestringStatement.setLong(prmIndex++, entity.getId());
                this.updateWayLinestringStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Update linestring failed for node " + entity.getId() + ".");
            }
        }
    }

    @Override
    public ReleasableIterator<Node> iterate() {
        return new NodeReader(this.getDatabaseContext());
    }
}

