/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SimpleObjectStore;
import org.openstreetmap.osmosis.core.store.Storeable;

public class PersistentIterator<T extends Storeable>
implements ReleasableIterator<T> {
    private ReleasableIterator<T> sourceIterator;
    private SimpleObjectStore<T> store;
    private ReleasableIterator<T> storeIterator;
    private boolean initialized;

    public PersistentIterator(ObjectSerializationFactory serializationFactory, ReleasableIterator<T> sourceIterator, String storageFilePrefix, boolean useCompression) {
        this.sourceIterator = sourceIterator;
        this.store = new SimpleObjectStore(serializationFactory, storageFilePrefix, useCompression);
        this.initialized = false;
    }

    private void initialize() {
        if (!this.initialized) {
            while (this.sourceIterator.hasNext()) {
                this.store.add((Storeable)this.sourceIterator.next());
            }
            this.sourceIterator.close();
            this.sourceIterator = null;
            this.storeIterator = this.store.iterate();
            this.initialized = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.initialize();
        return this.storeIterator.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (T)((Storeable)this.storeIterator.next());
    }

    @Override
    public void close() {
        if (this.storeIterator != null) {
            this.storeIterator.close();
            this.storeIterator = null;
        }
        this.store.close();
        if (this.sourceIterator != null) {
            this.sourceIterator.close();
            this.sourceIterator = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

