/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.core.store.IndexStoreReader;
import org.openstreetmap.osmosis.core.store.LongLongIndexElement;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStoreReader;

public class IndexedObjectStoreReader<T>
implements Closeable {
    private RandomAccessObjectStoreReader<T> objectStoreReader;
    private IndexStoreReader<Long, LongLongIndexElement> indexStoreReader;

    public IndexedObjectStoreReader(RandomAccessObjectStoreReader<T> objectStoreReader, IndexStoreReader<Long, LongLongIndexElement> indexStoreReader) {
        this.objectStoreReader = objectStoreReader;
        this.indexStoreReader = indexStoreReader;
    }

    public T get(long id) {
        long objectOffset = this.indexStoreReader.get(id).getValue();
        T data = this.objectStoreReader.get(objectOffset);
        return data;
    }

    @Override
    public void close() {
        this.objectStoreReader.close();
        this.indexStoreReader.close();
    }
}

