/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;

public class WayNode
implements Comparable<WayNode>,
Storeable {
    public static final String METADATA_KEY_LOCATION_INCLUDED = "way_node.location_included";
    private long nodeId;
    private double latitude;
    private double longitude;

    public WayNode(long nodeId) {
        this.nodeId = nodeId;
    }

    public WayNode(long nodeId, double latitude, double longitude) {
        this(nodeId);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public WayNode(StoreReader sr, StoreClassRegister scr) {
        this(sr.readLong(), sr.readDouble(), sr.readDouble());
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        sw.writeLong(this.nodeId);
        sw.writeDouble(this.latitude);
        sw.writeDouble(this.longitude);
    }

    @Override
    public int compareTo(WayNode wayNode) {
        long result = this.nodeId - wayNode.nodeId;
        if (result > 0L) {
            return 1;
        }
        if (result < 0L) {
            return -1;
        }
        return 0;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        return "WayNode(nodeID=" + this.getNodeId() + ")";
    }
}

