/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pbf2.v0_6.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.osmbinary.Osmformat;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.BlobToBlockMapper;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfBlobDecoderListener;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfBlock;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfFieldDecoder;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.RawBlob;

public class PbfBlobDecoder
implements Runnable {
    private static Logger log = Logger.getLogger(PbfBlobDecoder.class.getName());
    private static final int EMPTY_VERSION = -1;
    private static final Date EMPTY_TIMESTAMP = new Date(0L);
    private static final long EMPTY_CHANGESET = -1L;
    private BlobToBlockMapper blobToBlockMapper = new BlobToBlockMapper();
    private RawBlob rawBlob;
    private PbfBlobDecoderListener listener;
    private List<EntityContainer> decodedEntities;

    public PbfBlobDecoder(RawBlob rawBlob, PbfBlobDecoderListener listener) {
        this.rawBlob = rawBlob;
        this.listener = listener;
    }

    private void buildTags(CommonEntityData entityData, List<Integer> keys, List<Integer> values, PbfFieldDecoder fieldDecoder) {
        Collection tags = entityData.getTags();
        if (keys.size() != values.size()) {
            throw new OsmosisRuntimeException("Number of tag keys (" + keys.size() + ") and tag values (" + values.size() + ") don't match");
        }
        Iterator<Integer> keyIterator = keys.iterator();
        Iterator<Integer> valueIterator = values.iterator();
        while (keyIterator.hasNext()) {
            String key = fieldDecoder.decodeString(keyIterator.next());
            String value = fieldDecoder.decodeString(valueIterator.next());
            Tag tag = new Tag(key, value);
            tags.add(tag);
        }
    }

    private CommonEntityData buildCommonEntityData(long entityId, List<Integer> keys, List<Integer> values, Osmformat.Info info, PbfFieldDecoder fieldDecoder) {
        OsmUser user = info.hasUid() && info.getUid() >= 0 && info.hasUserSid() ? new OsmUser(info.getUid(), fieldDecoder.decodeString(info.getUserSid())) : OsmUser.NONE;
        CommonEntityData entityData = new CommonEntityData(entityId, info.getVersion(), fieldDecoder.decodeTimestamp(info.getTimestamp()), user, info.getChangeset());
        this.buildTags(entityData, keys, values, fieldDecoder);
        return entityData;
    }

    private CommonEntityData buildCommonEntityData(long entityId, List<Integer> keys, List<Integer> values, PbfFieldDecoder fieldDecoder) {
        CommonEntityData entityData = new CommonEntityData(entityId, -1, EMPTY_TIMESTAMP, OsmUser.NONE, -1L);
        this.buildTags(entityData, keys, values, fieldDecoder);
        return entityData;
    }

    private void processNodes(List<Osmformat.Node> nodes, PbfFieldDecoder fieldDecoder) {
        for (Osmformat.Node node : nodes) {
            CommonEntityData entityData = node.hasInfo() ? this.buildCommonEntityData(node.getId(), node.getKeysList(), node.getValsList(), node.getInfo(), fieldDecoder) : this.buildCommonEntityData(node.getId(), node.getKeysList(), node.getValsList(), fieldDecoder);
            Node osmNode = new Node(entityData, fieldDecoder.decodeLatitude(node.getLat()), fieldDecoder.decodeLongitude(node.getLon()));
            this.decodedEntities.add((EntityContainer)new NodeContainer(osmNode));
        }
    }

    private void processNodes(Osmformat.DenseNodes nodes, PbfFieldDecoder fieldDecoder) {
        List idList = nodes.getIdList();
        List latList = nodes.getLatList();
        List lonList = nodes.getLonList();
        if (idList.size() != latList.size() || idList.size() != lonList.size()) {
            throw new OsmosisRuntimeException("Number of ids (" + idList.size() + "), latitudes (" + latList.size() + "), and longitudes (" + lonList.size() + ") don't match");
        }
        Iterator keysValuesIterator = nodes.getKeysValsList().iterator();
        Osmformat.DenseInfo denseInfo = nodes.hasDenseinfo() ? nodes.getDenseinfo() : null;
        long nodeId = 0L;
        long latitude = 0L;
        long longitude = 0L;
        int userId = 0;
        int userSid = 0;
        long timestamp = 0L;
        long changesetId = 0L;
        for (int i = 0; i < idList.size(); ++i) {
            int keyIndex;
            CommonEntityData entityData;
            nodeId += ((Long)idList.get(i)).longValue();
            latitude += ((Long)latList.get(i)).longValue();
            longitude += ((Long)lonList.get(i)).longValue();
            if (denseInfo != null) {
                OsmUser user = (userId += denseInfo.getUid(i)) >= 0 ? new OsmUser(userId, fieldDecoder.decodeString(userSid += denseInfo.getUserSid(i))) : OsmUser.NONE;
                entityData = new CommonEntityData(nodeId, denseInfo.getVersion(i), fieldDecoder.decodeTimestamp(timestamp += denseInfo.getTimestamp(i)), user, changesetId += denseInfo.getChangeset(i));
            } else {
                entityData = new CommonEntityData(nodeId, -1, EMPTY_TIMESTAMP, OsmUser.NONE, -1L);
            }
            Collection tags = entityData.getTags();
            while (keysValuesIterator.hasNext() && (keyIndex = ((Integer)keysValuesIterator.next()).intValue()) != 0) {
                if (!keysValuesIterator.hasNext()) {
                    throw new OsmosisRuntimeException("The PBF DenseInfo keys/values list contains a key with no corresponding value.");
                }
                int valueIndex = (Integer)keysValuesIterator.next();
                Tag tag = new Tag(fieldDecoder.decodeString(keyIndex), fieldDecoder.decodeString(valueIndex));
                tags.add(tag);
            }
            Node node = new Node(entityData, fieldDecoder.decodeLatitude(latitude), fieldDecoder.decodeLongitude(longitude));
            this.decodedEntities.add((EntityContainer)new NodeContainer(node));
        }
    }

    private void processWays(List<Osmformat.Way> ways, PbfFieldDecoder fieldDecoder) {
        for (Osmformat.Way way : ways) {
            CommonEntityData entityData = way.hasInfo() ? this.buildCommonEntityData(way.getId(), way.getKeysList(), way.getValsList(), way.getInfo(), fieldDecoder) : this.buildCommonEntityData(way.getId(), way.getKeysList(), way.getValsList(), fieldDecoder);
            Way osmWay = new Way(entityData);
            long nodeId = 0L;
            long latitude = 0L;
            long longitude = 0L;
            List wayNodes = osmWay.getWayNodes();
            for (int i = 0; i < way.getRefsCount(); ++i) {
                nodeId += way.getRefs(i);
                if (i < way.getLatCount() && i < way.getLonCount()) {
                    wayNodes.add(new WayNode(nodeId, fieldDecoder.decodeLatitude(latitude += way.getLat(i)), fieldDecoder.decodeLongitude(longitude += way.getLon(i))));
                    continue;
                }
                wayNodes.add(new WayNode(nodeId));
            }
            this.decodedEntities.add((EntityContainer)new WayContainer(osmWay));
        }
    }

    private void buildRelationMembers(Relation relation, List<Long> memberIds, List<Integer> memberRoles, List<Osmformat.Relation.MemberType> memberTypes, PbfFieldDecoder fieldDecoder) {
        List members = relation.getMembers();
        if (memberIds.size() != memberRoles.size() || memberIds.size() != memberTypes.size()) {
            throw new OsmosisRuntimeException("Number of member ids (" + memberIds.size() + "), member roles (" + memberRoles.size() + "), and member types (" + memberTypes.size() + ") don't match");
        }
        Iterator<Long> memberIdIterator = memberIds.iterator();
        Iterator<Integer> memberRoleIterator = memberRoles.iterator();
        Iterator<Osmformat.Relation.MemberType> memberTypeIterator = memberTypes.iterator();
        long memberId = 0L;
        while (memberIdIterator.hasNext()) {
            EntityType entityType;
            Osmformat.Relation.MemberType memberType = memberTypeIterator.next();
            memberId += memberIdIterator.next().longValue();
            if (memberType == Osmformat.Relation.MemberType.NODE) {
                entityType = EntityType.Node;
            } else if (memberType == Osmformat.Relation.MemberType.WAY) {
                entityType = EntityType.Way;
            } else if (memberType == Osmformat.Relation.MemberType.RELATION) {
                entityType = EntityType.Relation;
            } else {
                throw new OsmosisRuntimeException("Member type of " + memberType + " is not supported.");
            }
            RelationMember member = new RelationMember(memberId, entityType, fieldDecoder.decodeString(memberRoleIterator.next()));
            members.add(member);
        }
    }

    private void processRelations(List<Osmformat.Relation> relations, PbfFieldDecoder fieldDecoder) {
        for (Osmformat.Relation relation : relations) {
            CommonEntityData entityData = relation.hasInfo() ? this.buildCommonEntityData(relation.getId(), relation.getKeysList(), relation.getValsList(), relation.getInfo(), fieldDecoder) : this.buildCommonEntityData(relation.getId(), relation.getKeysList(), relation.getValsList(), fieldDecoder);
            Relation osmRelation = new Relation(entityData);
            this.buildRelationMembers(osmRelation, relation.getMemidsList(), relation.getRolesSidList(), relation.getTypesList(), fieldDecoder);
            this.decodedEntities.add((EntityContainer)new RelationContainer(osmRelation));
        }
    }

    private void processOsmPrimitives(Osmformat.PrimitiveBlock block) {
        PbfFieldDecoder fieldDecoder = new PbfFieldDecoder(block);
        for (Osmformat.PrimitiveGroup primitiveGroup : block.getPrimitivegroupList()) {
            log.finer("Processing OSM primitive group.");
            this.processNodes(primitiveGroup.getDense(), fieldDecoder);
            this.processNodes(primitiveGroup.getNodesList(), fieldDecoder);
            this.processWays(primitiveGroup.getWaysList(), fieldDecoder);
            this.processRelations(primitiveGroup.getRelationsList(), fieldDecoder);
        }
    }

    private void runAndValidate() {
        this.decodedEntities = new ArrayList<EntityContainer>();
        PbfBlock pbfBlock = this.blobToBlockMapper.apply(this.rawBlob);
        if (pbfBlock.getHeaderBlock().isPresent()) {
            throw new OsmosisRuntimeException("Received more than one PBF header block.");
        }
        pbfBlock.getPrimitiveBlock().ifPresent(this::processOsmPrimitives);
    }

    @Override
    public void run() {
        try {
            this.runAndValidate();
            this.listener.complete(this.decodedEntities);
        }
        catch (RuntimeException e) {
            this.listener.error();
        }
    }
}

