/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.Collections;
import java.util.List;
import org.openstreetmap.osmosis.core.database.FeaturePopulator;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.NodeMapper;
import org.springframework.jdbc.core.JdbcTemplate;

public class NodeDao
extends EntityDao<Node> {
    private static final String SQL_UPDATE_WAY_BBOX = "UPDATE ways w SET bbox = ( SELECT ST_Envelope(ST_Collect(n.geom)) FROM nodes n INNER JOIN way_nodes wn ON wn.node_id = n.id WHERE wn.way_id = w.id ) WHERE w.id IN ( SELECT w.id FROM ways w INNER JOIN way_nodes wn ON w.id = wn.way_id WHERE wn.node_id = ? GROUP BY w.id )";
    private static final String SQL_UPDATE_WAY_LINESTRING = "UPDATE ways w SET linestring = ( SELECT ST_MakeLine(c.geom) AS way_line FROM ( SELECT n.geom AS geom FROM nodes n INNER JOIN way_nodes wn ON n.id = wn.node_id WHERE (wn.way_id = w.id) ORDER BY wn.sequence_id ) c ) WHERE w.id IN ( SELECT w.id FROM ways w INNER JOIN way_nodes wn ON w.id = wn.way_id WHERE wn.node_id = ? GROUP BY w.id )";
    private JdbcTemplate jdbcTemplate;
    private DatabaseCapabilityChecker capabilityChecker;

    public NodeDao(DatabaseContext dbCtx, ActionDao actionDao, boolean logging) {
        super(dbCtx.getJdbcTemplate(), new NodeMapper(), actionDao, logging);
        this.jdbcTemplate = dbCtx.getJdbcTemplate();
        this.capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
    }

    @Override
    public void modifyEntity(Node entity) {
        super.modifyEntity(entity);
        if (this.capabilityChecker.isWayBboxSupported()) {
            this.jdbcTemplate.update(SQL_UPDATE_WAY_BBOX, new Object[]{entity.getId()});
        }
        if (this.capabilityChecker.isWayLinestringSupported()) {
            this.jdbcTemplate.update(SQL_UPDATE_WAY_LINESTRING, new Object[]{entity.getId()});
        }
    }

    @Override
    protected List<FeaturePopulator<Node>> getFeaturePopulators(String tablePrefix) {
        return Collections.emptyList();
    }
}

