/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.osmosis;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.osmbinary.BinaryParser;
import org.openstreetmap.osmosis.osmbinary.Osmformat;

public class OsmosisBinaryParser
extends BinaryParser {
    static final int NOVERSION = -1;
    static final int NOCHANGESET = -1;
    private Sink sink;

    public void complete() {
        this.sink.complete();
    }

    OsmUser getUser(Osmformat.Info info) {
        if (info.hasUid() && info.hasUserSid()) {
            if (info.getUid() < 0) {
                return OsmUser.NONE;
            }
            return new OsmUser(info.getUid(), this.getStringById(info.getUserSid()));
        }
        return OsmUser.NONE;
    }

    protected void parseNodes(List<Osmformat.Node> nodes) {
        for (Osmformat.Node i : nodes) {
            Node tmp;
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (int j = 0; j < i.getKeysCount(); ++j) {
                tags.add(new Tag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j))));
            }
            long id = i.getId();
            double latf = this.parseLat(i.getLat());
            double lonf = this.parseLon(i.getLon());
            if (i.hasInfo()) {
                Osmformat.Info info = i.getInfo();
                tmp = new Node(new CommonEntityData(id, info.getVersion(), this.getDate(info), this.getUser(info), info.getChangeset(), tags), latf, lonf);
            } else {
                tmp = new Node(new CommonEntityData(id, -1, NODATE, OsmUser.NONE, -1L, tags), latf, lonf);
            }
            this.sink.process((EntityContainer)new NodeContainer(tmp));
        }
    }

    protected void parseDense(Osmformat.DenseNodes nodes) {
        long lastId = 0L;
        long lastLat = 0L;
        long lastLon = 0L;
        int j = 0;
        long lasttimestamp = 0L;
        long lastchangeset = 0L;
        int lastuserSid = 0;
        int lastuid = 0;
        Osmformat.DenseInfo di = null;
        if (nodes.hasDenseinfo()) {
            di = nodes.getDenseinfo();
        }
        for (int i = 0; i < nodes.getIdCount(); ++i) {
            Node tmp;
            long id;
            long lon;
            long lat;
            ArrayList<Tag> tags = new ArrayList<Tag>(0);
            lastLat = lat = nodes.getLat(i) + lastLat;
            lastLon = lon = nodes.getLon(i) + lastLon;
            lastId = id = nodes.getId(i) + lastId;
            double latf = this.parseLat(lat);
            double lonf = this.parseLon(lon);
            if (nodes.getKeysValsCount() > 0) {
                while (nodes.getKeysVals(j) != 0) {
                    int keyid = nodes.getKeysVals(j++);
                    int valid = nodes.getKeysVals(j++);
                    tags.add(new Tag(this.getStringById(keyid), this.getStringById(valid)));
                }
                ++j;
            }
            if (di != null) {
                long changeset;
                long timestamp;
                int userSid;
                int uid;
                lastuid = uid = di.getUid(i) + lastuid;
                lastuserSid = userSid = di.getUserSid(i) + lastuserSid;
                lasttimestamp = timestamp = di.getTimestamp(i) + lasttimestamp;
                int version = di.getVersion(i);
                lastchangeset = changeset = di.getChangeset(i) + lastchangeset;
                Date date = new Date((long)this.date_granularity * timestamp);
                OsmUser user = uid < 0 ? OsmUser.NONE : new OsmUser(uid, this.getStringById(userSid));
                tmp = new Node(new CommonEntityData(id, version, date, user, changeset, tags), latf, lonf);
            } else {
                tmp = new Node(new CommonEntityData(id, -1, NODATE, OsmUser.NONE, -1L, tags), latf, lonf);
            }
            this.sink.process((EntityContainer)new NodeContainer(tmp));
        }
    }

    protected void parseWays(List<Osmformat.Way> ways) {
        for (Osmformat.Way i : ways) {
            Way tmp;
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (int j = 0; j < i.getKeysCount(); ++j) {
                tags.add(new Tag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j))));
            }
            long lastId = 0L;
            long lastLat = 0L;
            long lastLon = 0L;
            ArrayList<WayNode> nodes = new ArrayList<WayNode>();
            for (int index = 0; index < i.getRefsCount(); ++index) {
                WayNode node;
                long identifier = lastId + i.getRefs(index);
                if (index < i.getLatCount() && index < i.getLonCount()) {
                    long lat = lastLat + i.getLat(index);
                    long lon = lastLon + i.getLon(index);
                    node = new WayNode(identifier, this.parseLat(lat), this.parseLon(lon));
                    lastLat = lat;
                    lastLon = lon;
                } else {
                    node = new WayNode(identifier);
                }
                nodes.add(node);
                lastId = identifier;
            }
            long id = i.getId();
            if (i.hasInfo()) {
                Osmformat.Info info = i.getInfo();
                tmp = new Way(new CommonEntityData(id, info.getVersion(), this.getDate(info), this.getUser(info), info.getChangeset(), tags), nodes);
            } else {
                tmp = new Way(new CommonEntityData(id, -1, NODATE, OsmUser.NONE, -1L, tags), nodes);
            }
            this.sink.process((EntityContainer)new WayContainer(tmp));
        }
    }

    protected void parseRelations(List<Osmformat.Relation> rels) {
        for (Osmformat.Relation i : rels) {
            Relation tmp;
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (int j = 0; j < i.getKeysCount(); ++j) {
                tags.add(new Tag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j))));
            }
            long id = i.getId();
            long lastMid = 0L;
            ArrayList<RelationMember> nodes = new ArrayList<RelationMember>();
            for (int j = 0; j < i.getMemidsCount(); ++j) {
                long mid;
                lastMid = mid = lastMid + i.getMemids(j);
                String role = this.getStringById(i.getRolesSid(j));
                EntityType etype = null;
                if (i.getTypes(j) == Osmformat.Relation.MemberType.NODE) {
                    etype = EntityType.Node;
                } else if (i.getTypes(j) == Osmformat.Relation.MemberType.WAY) {
                    etype = EntityType.Way;
                } else if (i.getTypes(j) == Osmformat.Relation.MemberType.RELATION) {
                    etype = EntityType.Relation;
                } else assert (false);
                nodes.add(new RelationMember(mid, etype, role));
            }
            if (i.hasInfo()) {
                Osmformat.Info info = i.getInfo();
                tmp = new Relation(new CommonEntityData(id, info.getVersion(), this.getDate(info), this.getUser(info), info.getChangeset(), tags), nodes);
            } else {
                tmp = new Relation(new CommonEntityData(id, -1, NODATE, OsmUser.NONE, -1L, tags), nodes);
            }
            this.sink.process((EntityContainer)new RelationContainer(tmp));
        }
    }

    public void parse(Osmformat.HeaderBlock block) {
        for (String s : block.getRequiredFeaturesList()) {
            if (s.equals("OsmSchema-V0.6") || s.equals("DenseNodes")) continue;
            throw new OsmosisRuntimeException("File requires unknown feature: " + s);
        }
        if (block.hasBbox()) {
            String source = "0.48.3";
            if (block.hasSource()) {
                source = block.getSource();
            }
            double multiplier = 1.0E-9;
            double rightf = (double)block.getBbox().getRight() * multiplier;
            double leftf = (double)block.getBbox().getLeft() * multiplier;
            double topf = (double)block.getBbox().getTop() * multiplier;
            double bottomf = (double)block.getBbox().getBottom() * multiplier;
            Bound bounds = new Bound(rightf, leftf, topf, bottomf, source);
            this.sink.process((EntityContainer)new BoundContainer(bounds));
        }
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

