/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import java.io.Serializable;

public class Point
implements Comparable<Point>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double x;
    public final double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int compareTo(Point point) {
        if (this.x > point.x) {
            return 1;
        }
        if (this.x < point.x) {
            return -1;
        }
        if (this.y > point.y) {
            return 1;
        }
        if (this.y < point.y) {
            return -1;
        }
        return 0;
    }

    public double distance(Point point) {
        return Math.hypot(this.x - point.x, this.y - point.y);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Point)) {
            return false;
        }
        Point other = (Point)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Point offset(double dx, double dy) {
        if (0.0 == dx && 0.0 == dy) {
            return this;
        }
        return new Point(this.x + dx, this.y + dy);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("x=");
        stringBuilder.append(this.x);
        stringBuilder.append(", y=");
        stringBuilder.append(this.y);
        return stringBuilder.toString();
    }
}

