/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;

public class GeometryMapper {
    public static Geometry map(Geometry geom, MapOp op) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry g2 = op.map(geom.getGeometryN(i));
            if (g2 == null) continue;
            mapped.add(g2);
        }
        return geom.getFactory().buildGeometry(mapped);
    }

    public static Collection map(Collection geoms, MapOp op) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        for (Geometry g2 : geoms) {
            Geometry gr = op.map(g2);
            if (gr == null) continue;
            mapped.add(gr);
        }
        return mapped;
    }

    public static interface MapOp {
        public Geometry map(Geometry var1);
    }
}

