/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext2;
import org.openstreetmap.osmosis.apidb.v0_6.impl.TransactionManager;
import org.openstreetmap.osmosis.apidb.v0_6.impl.TransactionSnapshot;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class TransactionDao
implements TransactionManager {
    private static final Logger LOG = Logger.getLogger(TransactionDao.class.getName());
    private DatabaseContext2 dbCtx;
    private JdbcTemplate jdbcTemplate;

    public TransactionDao(DatabaseContext2 dbCtx) {
        this.dbCtx = dbCtx;
        this.jdbcTemplate = dbCtx.getJdbcTemplate();
    }

    @Override
    public TransactionSnapshot getTransactionSnapshot() {
        String snapshotString = (String)this.jdbcTemplate.queryForObject("SELECT txid_current_snapshot()", String.class);
        TransactionSnapshot snapshot = new TransactionSnapshot(snapshotString);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Loaded new database snapshot, xmin=" + snapshot.getXMin() + ", xmax=" + snapshot.getXMax() + ", xiplist=" + snapshot.getXIpList());
        }
        return snapshot;
    }

    @Override
    public void executeWithinTransaction(final Runnable target) {
        this.dbCtx.executeWithinTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                target.run();
            }
        });
    }
}

