/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;

public class SchemaVersionValidator {
    private static Logger log = Logger.getLogger(SchemaVersionValidator.class.getName());
    private static final String SELECT_SQL = "SELECT version FROM schema_migrations";
    private final DatabaseLoginCredentials credentials;
    private final DatabasePreferences preferences;
    private boolean validated;

    public SchemaVersionValidator(DatabaseLoginCredentials credentials, DatabasePreferences preferences) {
        this.credentials = credentials;
        this.preferences = preferences;
    }

    public void validateVersion(String[] expectedMigrations) {
        if (!this.validated) {
            this.validateDBVersion(expectedMigrations);
            this.validated = true;
        }
    }

    private void validateDBVersion(String[] expectedMigrations) {
        block22: {
            if (this.preferences.getValidateSchemaVersion()) {
                try (DatabaseContext dbCtx = new DatabaseContext(this.credentials);){
                    HashSet<String> expectedMigrationSet = new HashSet<String>();
                    for (String expectedMigration : expectedMigrations) {
                        expectedMigrationSet.add(expectedMigration);
                    }
                    HashSet<String> actualMigrationSet = new HashSet<String>();
                    try (ResultSet resultSet = dbCtx.executeQuery(SELECT_SQL);){
                        while (resultSet.next()) {
                            actualMigrationSet.add(resultSet.getString("version"));
                        }
                    }
                    catch (SQLException e) {
                        throw new OsmosisRuntimeException("Unable to retrieve existing database migrations", (Throwable)e);
                    }
                    ArrayList<String> matchingMigrations = new ArrayList<String>();
                    for (String migration : expectedMigrationSet) {
                        if (!actualMigrationSet.contains(migration)) continue;
                        matchingMigrations.add(migration);
                    }
                    for (String migration : matchingMigrations) {
                        expectedMigrationSet.remove(migration);
                        actualMigrationSet.remove(migration);
                    }
                    if (expectedMigrationSet.size() <= 0 && actualMigrationSet.size() <= 0) break block22;
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append("Database version mismatch.");
                    if (expectedMigrationSet.size() > 0) {
                        errorMessage.append(" The schema is missing migrations " + expectedMigrationSet + ", may need to upgrade schema or specify validateSchemaVersion=no.");
                    }
                    if (actualMigrationSet.size() > 0) {
                        errorMessage.append(" The schema contains unexpected migrations " + actualMigrationSet + ", may need to upgrade osmosis or specify validateSchemaVersion=no.");
                    }
                    if (this.preferences.getAllowIncorrectSchemaVersion()) {
                        log.warning(errorMessage.toString());
                        break block22;
                    }
                    throw new OsmosisRuntimeException(errorMessage.toString());
                }
            }
        }
    }
}

