/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.ReleasableStatementContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.util.FixedPrecisionCoordinateConvertor;

public class ChangesetManager
implements Closeable {
    private static final int MAX_CHANGESET_ID_CACHE_SIZE = 32768;
    private static final String SQL_INSERT_CHANGESET = "INSERT INTO changesets (id, user_id, created_at, min_lat, max_lat, min_lon, max_lon, closed_at, num_changes) VALUES (?, ?, NOW(), " + FixedPrecisionCoordinateConvertor.convertToFixed((double)-90.0) + ", " + FixedPrecisionCoordinateConvertor.convertToFixed((double)90.0) + ", " + FixedPrecisionCoordinateConvertor.convertToFixed((double)-180.0) + ", " + FixedPrecisionCoordinateConvertor.convertToFixed((double)180.0) + ", NOW(), 0)";
    private static final String SQL_INSERT_CHANGESET_TAG = "INSERT INTO changeset_tags (changeset_id, k, v) VALUES (?, 'created_by', 'Osmosis 0.48.3'), (?, 'replication', 'true')";
    private static final String SQL_SELECT_CHANGESET_COUNT = "SELECT Count(*) AS changesetCount FROM changesets WHERE id = ?";
    private final DatabaseContext dbCtx;
    private final ReleasableContainer releasableContainer;
    private final ReleasableStatementContainer statementContainer;
    private PreparedStatement insertStatement;
    private PreparedStatement insertTagStatement;
    private PreparedStatement selectCountStatement;
    private Set<Long> knownChangesetIds;

    public ChangesetManager(DatabaseContext dbCtx) {
        this.dbCtx = dbCtx;
        this.releasableContainer = new ReleasableContainer();
        this.statementContainer = new ReleasableStatementContainer();
        this.releasableContainer.add((Closeable)this.statementContainer);
        this.knownChangesetIds = new LinkedHashSet<Long>(32768);
    }

    private int readChangesetCount(ResultSet countSet) {
        int n;
        block8: {
            ResultSet resultSet = countSet;
            try {
                resultSet.next();
                n = resultSet.getInt("changesetCount");
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to read the changeset count.", (Throwable)e);
                }
            }
            resultSet.close();
        }
        return n;
    }

    private boolean doesChangesetExist(long changesetId) {
        if (this.knownChangesetIds.contains(changesetId)) {
            return true;
        }
        if (this.selectCountStatement == null) {
            this.selectCountStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatementForStreaming(SQL_SELECT_CHANGESET_COUNT));
        }
        try {
            int prmIndex = 1;
            this.selectCountStatement.setLong(prmIndex++, changesetId);
            boolean changesetExists = this.readChangesetCount(this.selectCountStatement.executeQuery()) > 0;
            return changesetExists;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check if a changeset " + changesetId + " exists.", (Throwable)e);
        }
    }

    private void addChangeset(long changesetId, long userId) {
        if (this.insertStatement == null) {
            this.insertStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(SQL_INSERT_CHANGESET));
            this.insertTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(SQL_INSERT_CHANGESET_TAG));
        }
        try {
            int prmIndex = 1;
            this.insertStatement.setLong(prmIndex++, changesetId);
            this.insertStatement.setLong(prmIndex++, userId);
            this.insertStatement.executeUpdate();
            prmIndex = 1;
            this.insertTagStatement.setLong(prmIndex++, changesetId);
            this.insertTagStatement.setLong(prmIndex++, changesetId);
            this.insertTagStatement.executeUpdate();
            this.knownChangesetIds.add(changesetId);
            if (this.knownChangesetIds.size() > 32768) {
                Iterator<Long> i = this.knownChangesetIds.iterator();
                i.next();
                i.remove();
            }
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to insert a new changeset for user with id " + userId + ".", (Throwable)e);
        }
    }

    public void addChangesetIfRequired(long changesetId, OsmUser user) {
        if (!this.doesChangesetExist(changesetId)) {
            this.addChangeset(changesetId, user.getId());
        }
    }

    public void close() {
        this.releasableContainer.close();
    }
}

