VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CRect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Class CRect
'Used as a rectangle object for extents etc...
'
'Author Kenneth R. McVay
'Date December 24, 1998

Implements IShape

Private POINT1 As CPoint ' CPoint to hold upper left coord of rect
Private POINT2 As CPoint ' CPoint to hold lower right coord of rect
Private NullShape As Boolean


'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'PUBLIC PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'*****************************************************************************************
'get top
'returns the top coord of the rect
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Top() As Double
    Top = POINT1.Y
End Property

'*****************************************************************************************
'Get Left
'returns the left coord of the rect
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Left() As Double
    Left = POINT1.X
End Property

'*****************************************************************************************
'Get Bottom
'returns the bottom coord of the rect
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Bottom() As Double
    Bottom = POINT2.Y
End Property

'*****************************************************************************************
'Get Right
'returns the right coord of the rect
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Right() As Double
    Right = POINT2.X
End Property

'*****************************************************************************************
'let Top
'sets the top coord of the rect
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Let Top(ByVal aValue As Double)
    POINT1.Y = aValue
End Property

'*****************************************************************************************
'let Bottom
'sets the bottom coord of the rect
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Let Bottom(ByVal aValue As Double)
    POINT2.Y = aValue
End Property

'*****************************************************************************************
'let Left
'sets the left coord of the rect
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Let Left(ByVal aValue As Double)
    POINT1.X = aValue
End Property

'*****************************************************************************************
'Right
'sets the right coord of the rect
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Let Right(ByVal aValue As Double)
    POINT2.X = aValue
End Property

'=========================================================================================
'PUBLIC FUNCTIONS
'=========================================================================================
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'PUBLIC SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'*****************************************************************************************
'MakeEmpty
'sets the extents of the rect to 0
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Sub MakeEmpty()
    POINT1.X = 0
    POINT1.Y = 0
    POINT2.X = 0
    POINT2.Y = 0
End Sub

'*****************************************************************************************
'Make
'allows one to set the extents of the rect by passing points
'originPoint is top left
'sizePoint is bottom right
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Sub Make(ByVal originPoint As CPoint, ByVal sizePoint As CPoint)
    POINT1.X = originPoint.X
    POINT1.Y = originPoint.Y
    POINT2.X = sizePoint.X
    POINT2.Y = sizePoint.Y
End Sub

'*****************************************************************************************
'MakeXY
'allows one to set the extents of the rect by passing values
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Sub MakeXY(ByVal x1 As Double, ByVal y1 As Double, ByVal x2 As Double, ByVal y2 As Double)
    POINT1.X = x1
    POINT1.Y = y1
    POINT2.X = x2
    POINT2.X = y2
End Sub

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'FRIEND FUNCTIONS AND METHODS AND PROPERTIEs BELOW HERE
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'FRIEND PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'*****************************************************************************************
'SetNull
'a friend that allows the value of NullShape to be changed
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Friend Property Let SetNull(aNull As Boolean)
    NullShape = aNull
End Property
'=========================================================================================
'FRIEND FUNCTIONS
'=========================================================================================
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'FRIEND SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'PRIVATE FUNCTIONS AND METHODS AND PROPERTIES BELOW HERE
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'Private PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'*****************************************************************************************
'IShape_Bottom
'implementation of IShape Bottom()
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_Bottom() As Double
    IShape_Bottom = POINT2.Y
End Property

'*****************************************************************************************
'IShape_IsNull
'implementation of IShape IsNull()
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_IsNull() As Boolean
    IShape_IsNull = NullShape
End Property

'*****************************************************************************************
'Shape_Left
'implementation of IShape Left()
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_Left() As Double
    IShape_Left = POINT1.X
End Property

'*****************************************************************************************
'IShape_MakeNull
'implementation of IShape MakeNull()
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Let IShape_MakeNull(RHS As Boolean)
    NullShape = RHS
End Property

'*****************************************************************************************
'IShape_Right
'implementation of IShape Right
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_Right() As Double
    IShape_Right = POINT2.X
End Property

'*****************************************************************************************
'IShape_Top
'implementation of IShape top
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_Top() As Double
    IShape_Top = POINT1.Y
End Property

'=========================================================================================
'PRIVATE FUNCTIONS
'=========================================================================================

'*****************************************************************************************
'IShape_Distance
'Implementation of IShape Distance()
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Function IShape_Distance(aShape As Object) As Double
    MsgBox "NOT IMPLEMENTED"
    IShape_Distance = 0
End Function


'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'PRIVATE SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'*****************************************************************************************
'Class_Initialize
'creates the point objects for the extents
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Sub Class_Initialize()
    On Error GoTo ERROR_ROUTINE
    Set POINT1 = New CPoint
    Set POINT2 = New CPoint
    Exit Sub
ERROR_ROUTINE:
    Err.Source = "CRect::Class_Initialize"
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub

'*****************************************************************************************
'Class_Terminate
'destructs the point objects
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Sub Class_Terminate()
    Set POINT1 = Nothing
    Set POINT2 = Nothing
End Sub
