VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CPolygon"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Class CPolygon
'implements polygon shape types
'Author Kenneth R. McVay
'Date December 24, 1998

Option Explicit
Implements IShape

Private Extent As CRect
Private POLYG As Collection
Private NullShape As Boolean

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'PUBLIC PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'*****************************************************************************************
'Count
'returns the number of points in the Polygon collection
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Count() As Long
    Count = POLYG.Count
End Property

'=========================================================================================
'PUBLIC FUNCTIONS
'=========================================================================================

'*****************************************************************************************
'NewEnum
'for iterating over the collection
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Function NewEnum() As IUnknown
Attribute NewEnum.VB_UserMemId = -4
 Set NewEnum = POLYG.[_NewEnum]
End Function


'*****************************************************************************************
'Item
'Return CPart associated with index from polygon collection
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************

Public Function Item(ByVal index As Long) As CPart
    On Error GoTo ERROR_ROUTINE
        Set Item = POLYG.Item(index)
    Exit Function
ERROR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Function

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'PUBLIC SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'*****************************************************************************************
'Add
'Add a CPart to the polygon collection
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Sub Add(ByVal aPart As CPart)
    On Error GoTo ERROR_ROUTINE
    
    If (TypeName(aPart) = "CPart") Then
        If (POLYG.Count = 0) Then
            Extent.Left = aPart.Left
            Extent.Right = aPart.Right
            Extent.Bottom = aPart.Bottom
            Extent.Top = aPart.Top
        Else
            If (aPart.Left < Extent.Left) Then
                Extent.Left = aPart.Left
            End If
            If (aPart.Right > Extent.Right) Then
                Extent.Right = aPart.Right
            End If
            If (aPart.Bottom < Extent.Bottom) Then
                Extent.Bottom = aPart.Bottom
            End If
            If (aPart.Top > Extent.Top) Then
                Extent.Top = aPart.Top
            End If
        End If
    Else
        Err.Raise ERRORCODES.InvalidObject, "CPolygon::Add", _
            "CPolygon Add can only accept objects of type CPart"
    End If
    POLYG.Add aPart
    Exit Sub
ERROR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub


'*****************************************************************************************
'Remove
'Remove a CPart associated with index from the collection
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Sub Remove(ByVal index As Long)
    On Error GoTo ERROR_ROUTINE
    
    POLYG.Remove index
    
    Exit Sub
    
ERROR_ROUTINE:
    Err.Source = "C_Polygon::Remove"
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub


'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'FRIEND FUNCTIONS AND METHODS AND PROPERTIEs BELOW HERE
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'FRIEND PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'*****************************************************************************************
'SetNull
'set the shape to null
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Friend Property Let SetNull(aNull As Boolean)
    NullShape = aNull
End Property



'*****************************************************************************************
'Left
'set the left coord for polygon extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Friend Property Let Left(aValue As Double)
    Extent.Left = aValue
End Property

'*****************************************************************************************
'Right
'sets the right coord for polygon extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Friend Property Let Right(aValue As Double)
    Extent.Right = aValue
End Property

'*****************************************************************************************
'Top
'sets the top coord for the polygon extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Friend Property Let Top(aValue As Double)
    Extent.Top = aValue
End Property

'*****************************************************************************************
'Bottom
'sets the bottom coord for the polygon extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Friend Property Let Bottom(aValue As Double)
    Extent.Bottom = aValue
End Property

'=========================================================================================
'FRIEND FUNCTIONS
'=========================================================================================

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'FRIEND SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'PRIVATE FUNCTIONS AND METHODS AND PROPERTIES BELOW HERE
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'Private PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


'*****************************************************************************************
'IShape_Bottom
'implements IShape Bottom
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_Bottom() As Double
    IShape_Bottom = Extent.Bottom
End Property


'*****************************************************************************************
'IShape_IsNull
'implements IShape IsNull
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_IsNull() As Boolean
    IShape_IsNull = NullShape
End Property

'*****************************************************************************************
'IShape_Left
'implements IShape Left
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_Left() As Double
    IShape_Left = Extent.Left
End Property

'*****************************************************************************************
'IShape_MakeNull
'implements IShape MakeNull
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Let IShape_MakeNull(RHS As Boolean)
    NullShape = RHS
End Property

'*****************************************************************************************
'IShape_Right
'implements IShape Right
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_Right() As Double
    IShape_Right = Extent.Right
End Property

'*****************************************************************************************
'IShape_Top
'implements IShape Top
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Property Get IShape_Top() As Double
    IShape_Top = Extent.Top
End Property

'=========================================================================================
'PRIVATE FUNCTIONS
'=========================================================================================

'*****************************************************************************************
'IShape_Distance
'Implements IShape Distance
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Function IShape_Distance(aShape As Object) As Double
    MsgBox "NOT IMPLEMENTED"
    IShape_Distance = 0
End Function

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'PRIVATE SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'*****************************************************************************************
'Class_Initialize
'
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Sub Class_Initialize()
    Set Extent = New CRect
    Extent.MakeEmpty
    Set POLYG = New Collection
    NullShape = False
End Sub

'*****************************************************************************************
'Class_Terminate
'
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Sub Class_Terminate()
    Set Extent = Nothing
    Set POLYG = Nothing
End Sub





