VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CPart"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Class CPart
'Implements shape parts for polygons and polylines
'Author Kenneth R. McVay
'Date December 28, 1998

Option Explicit

Private part As Collection
Private Extent As CRect

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'PUBLIC PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'*****************************************************************************************
'Left
'returns the left coord of extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Left() As Double
    Left = Extent.Left
End Property

'*****************************************************************************************
'Left
'Sets the left coord of extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Let Left(aValue As Double)
    Extent.Left = aValue
End Property

'*****************************************************************************************
'Right
'returns the right coord of extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Right() As Double
    Right = Extent.Right
End Property

'*****************************************************************************************
'Right
'Sets the right coord of extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Let Right(aValue As Double)
    Extent.Right = aValue
End Property

'*****************************************************************************************
'Top
'returns the top coord of extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Top() As Double
    Top = Extent.Top
End Property

'*****************************************************************************************
'Top
'sets the top coord of extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Let Top(aValue As Double)
    Extent.Top = aValue
End Property

'*****************************************************************************************
'Bottom
'returns the bottom coord of extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Bottom() As Double
    Bottom = Extent.Bottom
End Property

'*****************************************************************************************
'Bottom
'sets the bottom coord of extent
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Let Bottom(aValue As Double)
    Extent.Bottom = aValue
End Property

'*****************************************************************************************
'Count
'returns the number of CPoints in the collection
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Property Get Count() As Long
    Count = part.Count
End Property


'=========================================================================================
'PUBLIC FUNCTIONS
'=========================================================================================

'*****************************************************************************************
'Item
'returns the point associated with index
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Function Item(ByVal index As Long) As CPoint
    On Error GoTo ERROR_ROUTINE
        Set Item = part.Item(index)
    Exit Function
ERROR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Function


'*****************************************************************************************
'NewEnum
'used for iterating over the collection
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Function NewEnum() As IUnknown
Attribute NewEnum.VB_UserMemId = -4
 Set NewEnum = part.[_NewEnum]
End Function

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'PUBLIC SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'*****************************************************************************************
'Remove
'removes a point associated with index from the part
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Sub Remove(ByVal index As Long)
    Dim apnt As CPoint
    Dim cnt As Long
    
    On Error GoTo ERROR_ROUTINE
    part.Remove index
    cnt = 1
    For Each apnt In part
        If (cnt = 1) Then
            Extent.Left = apnt.X
            Extent.Right = apnt.X
            Extent.Bottom = apnt.Y
            Extent.Top = apnt.Y
        Else
            If (apnt.X < Extent.Left) Then
                Extent.Left = apnt.X
            ElseIf (apnt.X > Extent.Right) Then
                Extent.Right = apnt.X
            End If
            If (apnt.Y < Extent.Bottom) Then
                Extent.Bottom = apnt.Y
            ElseIf (apnt.Y > Extent.Top) Then
                Extent.Top = apnt.Y
            End If
        End If
    Next
    Exit Sub
ERROR_ROUTINE:
    Err.Source = "CPart::Remove"
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub


'*****************************************************************************************
'Add
'Adds a point to the part collection
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Public Sub Add(ByVal aPoint As CPoint)
    On Error GoTo ERROR_ROUTINE
    
    If (TypeName(aPoint) <> "CPoint") Then
        Err.Raise ERRORCODES.InvalidObject, "CPart::Add", _
            "CPart can only accept objects of type CPoint"
    End If
    If (part.Count = 0) Then
        Extent.Make aPoint, aPoint
    Else
        If (aPoint.X < Extent.Left) Then
            Extent.Left = aPoint.X
        ElseIf (aPoint.X > Extent.Right) Then
            Extent.Right = aPoint.X
        End If
        If (aPoint.Y < Extent.Bottom) Then
            Extent.Bottom = aPoint.Y
        ElseIf (aPoint.Y > Extent.Top) Then
            Extent.Top = aPoint.Y
        End If
    End If
    part.Add aPoint
    Exit Sub
ERROR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'FRIEND FUNCTIONS AND METHODS AND PROPERTIEs BELOW HERE
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'FRIEND PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'=========================================================================================
'FRIEND FUNCTIONS
'=========================================================================================

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'FRIEND SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'PRIVATE FUNCTIONS AND METHODS AND PROPERTIES BELOW HERE
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'Private PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'=========================================================================================
'PRIVATE FUNCTIONS
'=========================================================================================

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'PRIVATE SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'*****************************************************************************************
'Class_Initialize
'
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Sub Class_Initialize()
    Set part = New Collection
    Set Extent = New CRect
End Sub

'*****************************************************************************************
'Class_Terminate
'
'Author Kenneth R. McVay
'Date December 24, 1998
'*****************************************************************************************
Private Sub Class_Terminate()
    Set part = Nothing
    Set Extent = Nothing
End Sub
