VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CFileName"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'**********************************************************************************
'Author : Kenneth R. McVay
'Date : December 16, 1998
'
'Class C_FileName
'Purpose : this class is used for easy manipulations of filenames.
'
'
'**********************************************************************************

Option Explicit
'**********************************************************************************
' This enum holds the errors generated by the class
Public Enum C_FileName_ERRORS
    FileSpecNotInitilized = vbObjectError + 512 + 2
    invalidFileSpec = vbObjectError + 512 + 3
End Enum

'**********************************************************************************
' Hold the private internal filespec passed in with SetFileSpec
Private FN As String

'**********************************************************************************
' Write Property SetFileSpec
' Parameters : FileSpec   a proper drive:\path\filename.ext
' On an error an exception will be generated
'Author Kenneth R. McVay
'Date December 24, 1998
'**********************************************************************************
Public Property Let SetFileSpec(FileSpec As String)
Dim aPos1 As Long
Dim aPos2 As Long
Dim aLen As Long
Dim str1 As String
Dim i As Long

    On Error GoTo ERROR_ROUTINE
    aLen = Len(FileSpec)
    If (aLen = 0) Then
     Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
        "The FileSpec is invalid"
    End If
    
    '*** Check for valid drive letter
    str1 = Mid(FileSpec, 1, 1)
    If (Asc(str1) > 90) Then
        If ((Asc(str1) < 97) Or (Asc(str1) > 122)) Then
            Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
             "The FileSpec is invalid"
        End If
    ElseIf ((Asc(str1) < 65) Or (Asc(str1) > 90)) Then
            Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
                "The FileSpec is invalid"
    End If
    If (Mid(FileSpec, 2, 1) <> ":") Then
        Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
        "The FileSpec is invalid"
    End If
    
    '*** check for .. or \\ which when two are together is invalid
    For i = 1 To aLen - 1
        If ((Mid(FileSpec, i, 1) = "\") And (Mid(FileSpec, i + 1, 1) = "\")) Then
            Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
                "The FileSpec is invalid"
        End If
        If ((Mid(FileSpec, i, 1) = ".") And (Mid(FileSpec, i + 1, 1) = ".")) Then
            Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
                "The FileSpec is invalid"
                
        End If
    Next
    
    '*** find the last \ and . in the filespec
    aPos1 = -1
    aPos2 = -1
    For i = 1 To aLen
        If (Mid(FileSpec, i, 1) = "\") Then
            aPos1 = i
        End If
        If (Mid(FileSpec, i, 1) = ".") Then
            aPos2 = i
        End If
    Next
    ' A \ and . has to be present for valid filespec
    If ((aPos1 = -1) Or (aPos2 = -1)) Then
        Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
                "The FileSpec is invalid"
    End If
    
    '*** check for invalid characters in file name
    For i = 3 To aLen
        str1 = Mid(FileSpec, i, 1)
        If ((str1 = "?") Or (Asc(str1) = 34) Or (str1 = "*") Or (str1 = "|") _
            Or (str1 = "/") Or (str1 = ">") Or (str1 = "<") Or (str1 = ":")) Then
            
            Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
                "The FileSpec is invalid"
        End If
    Next
    For i = aPos1 + 1 To aLen
        str1 = Mid(FileSpec, i, 1)
        If (str1 = "\") Then
            Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetFileSpec", _
                "The FileSpec is invalid"
        End If
    Next
    FN = FileSpec
    Exit Property
ERROR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Property

'**********************************************************************************
' Read Property GetFileSpec
' Returns the drive:\path\filename.ext which is held in the private class
' variable FN
'Author Kenneth R. McVay
'Date December 24, 1998
'**********************************************************************************
Public Property Get GetFileSpec() As String
    GetFileSpec = FN
End Property

'**********************************************************************************
'Read Property GetBaseName
' Returns the filename associated with the private variable FN.
'
'Author Kenneth R. McVay
'Date December 24, 1998
'**********************************************************************************
Public Property Get GetBaseName() As String
Dim aPos1 As Long
Dim aPos2 As Long
Dim aLen As Long
Dim i As Long

    aLen = Len(FN)
    If (aLen = 0) Then
        GetBaseName = ""
    End If
    For i = 1 To aLen
        If (Mid(FN, i, 1) = "\") Then
            aPos1 = i
        End If
        If (Mid(FN, i, 1) = ".") Then
            aPos2 = i
        End If
    Next
    GetBaseName = Mid(FN, aPos1 + 1, aPos2 - aPos1 - 1)
End Property

'**********************************************************************************
'Write Property SetBaseName   allows one to change the base name of a filespec
'       in the private variable FN
'Parameters : aName   the name (suffix) protion of the filename
'Raises and exception on error
'Author Kenneth R. McVay
'Date December 24, 1998
'**********************************************************************************
Public Property Let SetBaseName(aName As String)
Dim aPos1 As Long
Dim aPos2 As Long
Dim aLen As Long
Dim path As String
Dim ext As String
Dim str1 As String
Dim i As Long
    
    On Error GoTo ERROR_ROUTINE
    
    '*** check for validity
    If (Len(aName) = 0) Then
        Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetBaseName", _
                "The FileSpec is invalid"
    End If
    For i = 1 To Len(aName)
        str1 = Mid(aName, i, 1)
        If ((str1 = "?") Or (Asc(str1) = 34) Or (str1 = "*") Or (str1 = "|") _
            Or (str1 = "/") Or (str1 = ">") Or (str1 = "<") Or (str1 = ":") _
            Or (str1 = "\")) Then
            
            Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetBaseName", _
                "The FileSpec is invalid"
        End If
    Next
    
    '*** find the last \ and .
    aLen = Len(FN)
    For i = 1 To aLen
        If (Mid(FN, i, 1) = "\") Then
            aPos1 = i
        End If
        If (Mid(FN, i, 1) = ".") Then
            aPos2 = i
        End If
    Next
    path = Mid(FN, 1, aPos1)
    ext = Mid(FN, aPos2, aLen - aPos2 + 1)
    FN = path & aName & ext
    Exit Property
ERROR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Property

'**********************************************************************************
'Read Property GetExtension
' Returns the Extension portion of the filename in the private variable
' FN
'
'Author Kenneth R. McVay
'Date December 24, 1998
'**********************************************************************************
Public Property Get GetExtension() As String
Dim i As Long
Dim aPos As Long

    For i = 1 To Len(FN)
        If (Mid(FN, i, 1) = ".") Then
            aPos = i
        End If
    Next
    GetExtension = Mid(FN, aPos + 1, Len(FN) - aPos)

End Property

'**********************************************************************************
' Write Property SetExtension used to set the extension of the private filespec
'               variable FN
' Parameters aExt the new extension to set
' Raises exception on error
'Author Kenneth R. McVay
'Date December 24, 1998
'**********************************************************************************
Public Property Let SetExtension(aExt As String)
Dim str1 As String
Dim aPos As Long
Dim i As Long
Dim aLen As Long

    On Error GoTo ERROR_ROUTINE
    '*** check for validity
    If (Len(aExt) = 0) Then
        Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetBaseName", _
                "The FileSpec is invalid"
    End If
    For i = 1 To Len(aExt)
        str1 = Mid(aExt, i, 1)
        If ((str1 = "?") Or (Asc(str1) = 34) Or (str1 = "*") Or (str1 = "|") _
            Or (str1 = "/") Or (str1 = ">") Or (str1 = "<") Or (str1 = ":") _
            Or (str1 = "\")) Then
            
            Err.Raise C_FileName_ERRORS.invalidFileSpec, "C_FileName::SetExtension", _
                "The FileSpec is invalid"
        End If
    Next
    aLen = Len(FN)
    For i = 1 To aLen
        If (Mid(FN, i, 1) = ".") Then
            aPos = i
        End If
    Next
    str1 = Mid(FN, 1, aPos)
    FN = str1 & aExt
    Exit Property
ERROR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Property

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'PUBLIC SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++




'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'FRIEND FUNCTIONS AND METHODS AND PROPERTIEs BELOW HERE
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'FRIEND PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'=========================================================================================
'FRIEND FUNCTIONS
'=========================================================================================

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'FRIEND SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'PRIVATE FUNCTIONS AND METHODS AND PROPERTIES BELOW HERE
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'Private PROPERTIES
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'=========================================================================================
'PRIVATE FUNCTIONS
'=========================================================================================

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'PRIVATE SUBS
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'**********************************************************************************
'Author Kenneth R. McVay
'Date December 24, 1998
Private Sub Class_Initialize()
    FN = ""
End Sub
'**********************************************************************************
